/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import club.sk1er.org.apache.commons.lang3.builder.EqualsBuilder;
import club.sk1er.org.apache.commons.lang3.builder.HashCodeBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.languagetool.Experimental;
import org.languagetool.LinguServices;

@Experimental
public class UserConfig {
    private final List<String> userSpecificSpellerWords;
    private final int maxSpellingSuggestions;
    private final String userDictName;
    private final Map<String, Integer> configurableRuleValues = new HashMap<String, Integer>();
    private final LinguServices linguServices;
    private long textSessionId;
    private String abTest;

    public UserConfig() {
        this(new ArrayList<String>(), new HashMap<String, Integer>());
    }

    public UserConfig(List<String> userSpecificSpellerWords) {
        this(userSpecificSpellerWords, new HashMap<String, Integer>());
    }

    public UserConfig(Map<String, Integer> ruleValues) {
        this(new ArrayList<String>(), Objects.requireNonNull(ruleValues));
    }

    public UserConfig(Map<String, Integer> ruleValues, LinguServices linguServices) {
        this(new ArrayList<String>(), Objects.requireNonNull(ruleValues), 0, null, linguServices);
    }

    public UserConfig(List<String> userSpecificSpellerWords, Map<String, Integer> ruleValues) {
        this(userSpecificSpellerWords, ruleValues, 0);
    }

    public UserConfig(List<String> userSpecificSpellerWords, Map<String, Integer> ruleValues, int maxSpellingSuggestions) {
        this(userSpecificSpellerWords, ruleValues, maxSpellingSuggestions, null, null);
    }

    public UserConfig(List<String> userSpecificSpellerWords, Map<String, Integer> ruleValues, int maxSpellingSuggestions, String userDictName, LinguServices linguServices) {
        this.userSpecificSpellerWords = Objects.requireNonNull(userSpecificSpellerWords);
        for (Map.Entry<String, Integer> entry : ruleValues.entrySet()) {
            this.configurableRuleValues.put(entry.getKey(), entry.getValue());
        }
        this.maxSpellingSuggestions = maxSpellingSuggestions;
        this.userDictName = userDictName == null ? "default" : userDictName;
        this.linguServices = linguServices;
    }

    public List<String> getAcceptedWords() {
        return this.userSpecificSpellerWords;
    }

    public int getMaxSpellingSuggestions() {
        return this.maxSpellingSuggestions;
    }

    public Map<String, Integer> getConfigValues() {
        return this.configurableRuleValues;
    }

    public void insertConfigValues(Map<String, Integer> ruleValues) {
        for (Map.Entry<String, Integer> entry : ruleValues.entrySet()) {
            this.configurableRuleValues.put(entry.getKey(), entry.getValue());
        }
    }

    public int getConfigValueByID(String ruleID) {
        if (this.configurableRuleValues.containsKey(ruleID)) {
            return this.configurableRuleValues.get(ruleID);
        }
        return -1;
    }

    public boolean hasLinguServices() {
        return this.linguServices != null;
    }

    public LinguServices getLinguServices() {
        return this.linguServices;
    }

    public String getUserDictName() {
        return this.userDictName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserConfig other = (UserConfig)o;
        return new EqualsBuilder().append(this.maxSpellingSuggestions, other.maxSpellingSuggestions).append(this.configurableRuleValues, other.configurableRuleValues).append(this.userDictName, other.userDictName).append(this.userSpecificSpellerWords, other.userSpecificSpellerWords).append(this.abTest, other.abTest).append(this.textSessionId % 2L, other.textSessionId % 2L).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(3, 11).append(this.maxSpellingSuggestions).append(this.userDictName).append(this.configurableRuleValues).toHashCode();
    }

    public void setTextSessionId(Long textSessionId) {
        this.textSessionId = textSessionId;
    }

    public Long getTextSessionId() {
        return this.textSessionId;
    }

    public String getAbTest() {
        return this.abTest;
    }

    public void setAbTest(String abTest) {
        this.abTest = abTest;
    }
}

